capture program drop selectType
program define selectType

version 13.1
*! version 1.0 January 22, 2016

syntax   [, context(int 0) individual(int 0) contextExt(int 0) individualExt(int 0) ]

display ""
display "Start of the program SELECT TYPE"
which selectType
display ""


qui{
use METADATA.dta, clear
keep if Value=="Definition"
keep Type Explanation
tempfile explanation
save `explanation', replace
}

if `contextExt' == 1{
qui use CONTEXT_EXT.dta, clear

qui{
keep Type
bysort Type: gen row = _n
keep if row ==1
merge 1:1 Type using `explanation'
keep if _merge==3
keep Type Explanation
gen Select=.
gen Duration = .
}

qui export excel using CONTEXT_EXT_SELECT.xls, firstrow(variables)  replace
display "	File CONTEXT_EXT_SELECT.xls saved." 

}

if `context' == 1{
qui use CONTEXT.dta, clear

qui{
keep Type
bysort Type: gen row = _n
keep if row ==1
merge 1:1 Type using `explanation'
keep if _merge==3
keep Type Explanation
gen Select=.
gen Duration = .
}

qui export excel using CONTEXT_SELECT.xls, firstrow(variables)  replace
display "	File CONTEXT_SELECT.xls saved." 

}

if `individual' == 1{
qui use INDIVIDUAL.dta, clear

qui{
keep Type
bysort Type: gen row = _n
keep if row ==1
merge 1:1 Type using `explanation'
keep if _merge==3
keep Type Explanation
gen Select=.
gen Duration = .
}
qui export excel using INDIVIDUAL_SELECT.xls, firstrow(variables)  replace
display "	File INDIVIDUAL_SELECT.xls saved." 
}

if `individualExt' == 1{
qui use INDIVIDUAL_EXT.dta, clear

qui{
keep Type
bysort Type: gen row = _n
keep if row ==1
merge 1:1 Type using `explanation'
keep if _merge==3
keep Type Explanation
gen Select=.
gen Duration = .
}
qui export excel using INDIVIDUAL_EXT_SELECT.xls, firstrow(variables)  replace
display "	File INDIVIDUAL_EXT_SELECT.xls saved." 

}



display ""
display "Open your saved file and select the desired Types by inserting a 1 on the column Select."
display ""
display "When running the program EpisodesFileCreator the values of all variables except events "
display "are copied down. For variables where the values are only valid on their date of declaration"
display "instert Instant in the field Duration, and for variables where the value is valid between" 
display "the date of declaration and the next date of declaration / end_date insert the value Continuous." 
display ""
display "Save and close the Excel file after making these choices"
display ""
display "End of the program SELECT TYPE"
end
